/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher;

import club.sk1er.patcher.commands.DeleteNameHistoryCommand;
import club.sk1er.patcher.commands.InventoryScaleCommand;
import club.sk1er.patcher.commands.PatcherCommand;
import club.sk1er.patcher.commands.PatcherPlayer;
import club.sk1er.patcher.commands.PatcherPlayerArgumentParser;
import club.sk1er.patcher.commands.PatcherSoundsCommand;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.config.PatcherSoundConfig;
import club.sk1er.patcher.ducks.FontRendererExt;
import club.sk1er.patcher.hooks.EntityRendererHook;
import club.sk1er.patcher.hooks.MinecraftHook;
import club.sk1er.patcher.render.HistoryPopUp;
import club.sk1er.patcher.render.ScreenshotPreview;
import club.sk1er.patcher.screen.PatcherMenuEditor;
import club.sk1er.patcher.screen.render.caching.HUDCaching;
import club.sk1er.patcher.screen.render.overlay.ArmorStatusRenderer;
import club.sk1er.patcher.screen.render.overlay.GlanceRenderer;
import club.sk1er.patcher.screen.render.overlay.ImagePreview;
import club.sk1er.patcher.screen.render.overlay.OverlayHandler;
import club.sk1er.patcher.screen.render.overlay.metrics.MetricsRenderer;
import club.sk1er.patcher.screen.render.title.TitleFix;
import club.sk1er.patcher.tweaker.PatcherTweaker;
import club.sk1er.patcher.util.chat.ChatHandler;
import club.sk1er.patcher.util.enhancement.EnhancementManager;
import club.sk1er.patcher.util.enhancement.ReloadListener;
import club.sk1er.patcher.util.fov.FovHandler;
import club.sk1er.patcher.util.keybind.FunctionKeyChanger;
import club.sk1er.patcher.util.keybind.KeybindDropModifier;
import club.sk1er.patcher.util.keybind.KeybindNameHistory;
import club.sk1er.patcher.util.keybind.MousePerspectiveKeybindHandler;
import club.sk1er.patcher.util.keybind.linux.LinuxKeybindFix;
import club.sk1er.patcher.util.screenshot.AsyncScreenshots;
import club.sk1er.patcher.util.world.SavesWatcher;
import club.sk1er.patcher.util.world.WorldHandler;
import club.sk1er.patcher.util.world.render.culling.EntityCulling;
import club.sk1er.patcher.util.world.render.entity.EntityRendering;
import club.sk1er.patcher.util.world.render.entity.NameHistoryTracer;
import club.sk1er.patcher.util.world.sound.SoundHandler;
import club.sk1er.patcher.util.world.sound.audioswitcher.AudioSwitcher;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gg.essential.api.EssentialAPI;
import gg.essential.api.commands.ArgumentParser;
import gg.essential.api.commands.Command;
import gg.essential.api.gui.Notifications;
import gg.essential.api.utils.Multithreading;
import gg.essential.api.utils.WebUtil;
import gg.essential.universal.UDesktop;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="patcher", name="Patcher", version="1.8.2", clientSideOnly=true)
public class Patcher {
    @Mod.Instance(value="patcher")
    public static Patcher instance;
    public static final String VERSION = "1.8.2";
    private final Logger logger = LogManager.getLogger((String)"Patcher");
    private final File logsDirectory;
    private final Set<String> blacklistedServers;
    private final File blacklistedServersFile;
    private final SavesWatcher savesWatcher;
    private final AudioSwitcher audioSwitcher;
    private KeyBinding dropModifier;
    private KeyBinding nameHistory;
    private KeyBinding hideScreen;
    private KeyBinding customDebug;
    private KeyBinding clearShaders;
    private PatcherConfig patcherConfig;
    private PatcherSoundConfig patcherSoundConfig;
    private boolean loadedGalacticFontRenderer;

    public Patcher() {
        this.logsDirectory = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "logs" + File.separator);
        this.blacklistedServers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.blacklistedServersFile = new File("./config/blacklisted_servers.txt");
        this.savesWatcher = new SavesWatcher();
        this.audioSwitcher = new AudioSwitcher();
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        this.nameHistory = new KeybindNameHistory();
        this.dropModifier = new KeybindDropModifier();
        this.hideScreen = new FunctionKeyChanger.KeybindHideScreen();
        this.customDebug = new FunctionKeyChanger.KeybindCustomDebug();
        this.clearShaders = new FunctionKeyChanger.KeybindClearShaders();
        this.registerKeybinds(this.nameHistory, this.dropModifier, this.hideScreen, this.customDebug, this.clearShaders);
        this.patcherConfig = PatcherConfig.INSTANCE;
        this.patcherSoundConfig = new PatcherSoundConfig();
        SoundHandler soundHandler = new SoundHandler();
        IReloadableResourceManager resourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        resourceManager.func_110542_a((IResourceManagerReloadListener)soundHandler);
        resourceManager.func_110542_a((IResourceManagerReloadListener)new ReloadListener());
        this.registerCommands(new PatcherCommand(), new PatcherSoundsCommand(), new InventoryScaleCommand(), new AsyncScreenshots.FavoriteScreenshot(), new AsyncScreenshots.DeleteScreenshot(), new AsyncScreenshots.UploadScreenshot(), new AsyncScreenshots.CopyScreenshot(), new AsyncScreenshots.ScreenshotsFolder(), new DeleteNameHistoryCommand());
        EssentialAPI.getCommandRegistry().registerParser(PatcherPlayer.class, (ArgumentParser)new PatcherPlayerArgumentParser());
        this.registerEvents(new Object[]{this, soundHandler, this.dropModifier, this.audioSwitcher, new OverlayHandler(), new EntityRendering(), new FovHandler(), new ChatHandler(), new GlanceRenderer(), new EntityCulling(), new ArmorStatusRenderer(), new NameHistoryTracer(), new PatcherMenuEditor(), new ImagePreview(), new WorldHandler(), new TitleFix(), new LinuxKeybindFix(), new MetricsRenderer(), new HUDCaching(), new EntityRendererHook(), MinecraftHook.INSTANCE, ScreenshotPreview.INSTANCE, HistoryPopUp.INSTANCE, new MousePerspectiveKeybindHandler()});
        this.checkLogs();
        this.loadBlacklistedServers();
        this.fixSettings();
        this.savesWatcher.watch();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        if (!this.loadedGalacticFontRenderer) {
            this.loadedGalacticFontRenderer = true;
            FontRenderer galacticFontRenderer = Minecraft.func_71410_x().field_71464_q;
            if (galacticFontRenderer instanceof FontRendererExt) {
                ((FontRendererExt)galacticFontRenderer).patcher$getFontRendererHook().create();
            }
        }
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        List activeModList = Loader.instance().getActiveModList();
        Notifications notifications = EssentialAPI.getNotifications();
        this.detectIncompatibilities(activeModList, notifications);
        this.detectReplacements(activeModList, notifications);
        long time = (System.currentTimeMillis() - PatcherTweaker.clientLoadTime) / 1000L;
        if (PatcherConfig.startupNotification) {
            notifications.push("Minecraft Startup", "Minecraft started in " + time + " seconds.");
        }
        this.logger.info("Minecraft started in {} seconds.", (Object)time);
        if (!"1.12.2".equals("1.8.9") || ForgeVersion.getVersion().contains("2318")) {
            return;
        }
        notifications.push("Patcher", "Outdated Forge has been detected (" + ForgeVersion.getVersion() + "). Click to open the Forge website to download the latest version.", 30.0f, () -> {
            String updateLink = "https://files.minecraftforge.net/net/minecraftforge/forge/index_1.8.9.html";
            try {
                UDesktop.browse((URI)URI.create(updateLink));
            }
            catch (Exception openException) {
                this.logger.error("Failed to open Forge website.", (Throwable)openException);
                notifications.push("Patcher", "Failed to open Forge website. Link is now copied to your clipboard.");
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(updateLink), null);
                }
                catch (Exception clipboardException) {
                    this.logger.error("Failed to copy Forge website to clipboard.", (Throwable)clipboardException);
                    notifications.push("Patcher", "Failed to copy Forge website to clipboard.");
                }
            }
            return Unit.INSTANCE;
        });
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EnhancementManager.getInstance().tick();
        }
    }

    private void checkLogs() {
        if (PatcherConfig.logOptimizer && this.logsDirectory.exists()) {
            File[] files = this.logsDirectory.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (!file.getName().endsWith("log.gz") || file.lastModified() > System.currentTimeMillis() - (long)PatcherConfig.logOptimizerLength * 86400000L) continue;
                file.delete();
            }
        }
    }

    private void registerKeybinds(KeyBinding ... keybinds) {
        for (KeyBinding keybind : keybinds) {
            ClientRegistry.registerKeyBinding((KeyBinding)keybind);
        }
    }

    private void registerEvents(Object ... events) {
        for (Object event : events) {
            MinecraftForge.EVENT_BUS.register(event);
        }
    }

    private void registerCommands(Command ... commands) {
        for (Command command : commands) {
            EssentialAPI.getCommandRegistry().registerCommand(command);
        }
    }

    private boolean isServerBlacklisted(String ip) {
        if (ip == null) {
            return false;
        }
        String trim = ip.trim();
        return !trim.isEmpty() && this.blacklistedServers.contains(trim);
    }

    public boolean addOrRemoveBlacklist(String input) {
        if (input == null || input.isEmpty() || input.trim().isEmpty()) {
            return false;
        }
        if (this.isServerBlacklisted(input = input.trim())) {
            this.blacklistedServers.remove(input);
            return false;
        }
        this.blacklistedServers.add(input);
        return true;
    }

    public void saveBlacklistedServers() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.blacklistedServersFile));){
            File parentFile = this.blacklistedServersFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                return;
            }
            if (!this.blacklistedServersFile.exists() && !this.blacklistedServersFile.createNewFile()) {
                return;
            }
            for (String server : this.blacklistedServers) {
                writer.write(server + System.lineSeparator());
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to save blacklisted servers.", (Throwable)e);
        }
    }

    private void loadBlacklistedServers() {
        if (!this.blacklistedServersFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.blacklistedServersFile));){
            String servers;
            while ((servers = reader.readLine()) != null) {
                this.blacklistedServers.add(servers);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to load blacklisted servers.", (Throwable)e);
        }
    }

    private void fixSettings() {
        if (PatcherConfig.customZoomSensitivity > 1.0f) {
            PatcherConfig.customZoomSensitivity = 1.0f;
        }
        if (PatcherConfig.tabOpacity > 1.0f) {
            PatcherConfig.tabOpacity = 1.0f;
        }
        if (PatcherConfig.imagePreviewWidth > 1.0f) {
            PatcherConfig.imagePreviewWidth = 0.5f;
        }
        if (PatcherConfig.previewScale > 1.0f) {
            PatcherConfig.previewScale = 1.0f;
        }
        if (PatcherConfig.unfocusedFPSAmount < 15) {
            PatcherConfig.unfocusedFPSAmount = 15;
        }
        if (PatcherConfig.fireOverlayHeight < -0.5f || PatcherConfig.fireOverlayHeight > 1.5f) {
            PatcherConfig.fireOverlayHeight = 0.0f;
        }
        this.forceSaveConfig();
    }

    private void detectIncompatibilities(List<ModContainer> activeModList, Notifications notifications) {
        for (ModContainer container : activeModList) {
            String modId = container.getModId();
            String baseMessage = container.getName() + " has been detected. ";
            if (PatcherConfig.entityCulling && modId.equals("enhancements")) {
                notifications.push("Patcher", baseMessage + "Entity Culling is now disabled.");
                PatcherConfig.entityCulling = false;
            }
            if (modId.equals("labymod") || modId.equals("enhancements") || modId.equals("hychat")) {
                if (PatcherConfig.compactChat) {
                    notifications.push("Patcher", baseMessage + "Compact Chat is now disabled.");
                    PatcherConfig.compactChat = false;
                }
                if (PatcherConfig.chatPosition) {
                    notifications.push("Patcher", baseMessage + "Chat Position is now disabled.");
                    PatcherConfig.chatPosition = false;
                }
            }
            if (!PatcherConfig.optimizedFontRenderer || !modId.equals("smoothfont")) continue;
            notifications.push("Patcher", baseMessage + "Optimized Font Renderer is now disabled.");
            PatcherConfig.optimizedFontRenderer = false;
        }
        this.forceSaveConfig();
    }

    private void detectReplacements(List<ModContainer> activeModList, Notifications notifications) {
        JsonObject replacedMods;
        try {
            replacedMods = this.readDuplicateModsJson().get();
        }
        catch (Exception e) {
            this.logger.error("Failed to fetch list of replaced mods.", (Throwable)e);
            return;
        }
        if (replacedMods == null) {
            return;
        }
        HashSet<String> replacements = new HashSet<String>();
        Set jsonKey = replacedMods.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        for (ModContainer modContainer : activeModList) {
            for (String modid : jsonKey) {
                if (!modContainer.getModId().contains(modid) || replacements.contains(modid)) continue;
                replacements.add(modContainer.getName());
            }
        }
        if (!replacements.isEmpty()) {
            for (String replacement : replacements) {
                notifications.push("Patcher", replacement + " can be removed as it is replaced by Patcher.", 6.0f);
            }
        }
    }

    private CompletableFuture<JsonObject> readDuplicateModsJson() {
        String url = "https://static.sk1er.club/patcher/duplicate_mods.json";
        return CompletableFuture.supplyAsync(() -> new JsonParser().parse(Objects.requireNonNull(WebUtil.fetchString((String)url))).getAsJsonObject(), Multithreading.getPool()).exceptionally(error -> {
            this.logger.error("Failed to fetch {}: {}", (Object)url, error);
            return null;
        });
    }

    public PatcherConfig getPatcherConfig() {
        return this.patcherConfig;
    }

    public PatcherSoundConfig getPatcherSoundConfig() {
        return this.patcherSoundConfig;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public KeyBinding getNameHistory() {
        return this.nameHistory;
    }

    public KeyBinding getDropModifier() {
        return this.dropModifier;
    }

    public KeyBinding getHideScreen() {
        return this.hideScreen;
    }

    public KeyBinding getCustomDebug() {
        return this.customDebug;
    }

    public KeyBinding getClearShaders() {
        return this.clearShaders;
    }

    public AudioSwitcher getAudioSwitcher() {
        return this.audioSwitcher;
    }

    public void forceSaveConfig() {
        this.patcherConfig.markDirty();
        this.patcherConfig.writeData();
    }
}

